<?php $__env->startSection("title", "Categories"); ?>
<?php $__env->startSection("content"); ?>
<a href="<?php echo e(route('categories.create')); ?>" class="btn btn-primary mb-3">Add New Category</a>
    <table class="table table-bordered table-hover">
        <thead>
            <th>លេខរៀង</th>
            <th>ឈ្មោះ</th>
            <th>Parent Category</th>
            <th>បរិយាយ</th>
            <th>រូបភាព</th>
            <th>Status</th>
            <th>សកម្មភាព</th>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($loop->iteration); ?></td>
                    <td><?php echo e($category->name); ?></td>
                    <td><?php echo e($category->parent->name ?? 'No Parent'); ?></td>
                    <td><?php echo e($category->description); ?></td>
                    <td>
                        <img src="<?php echo e($category->image && file_exists(public_path('storage/' . $category->image))
                            ? asset('storage/' . $category->image)
                            : asset('images/no_image.png')); ?>"
                            alt="<?php echo e($category->name); ?>"
                            width="50"
                            height="50"/>
                    </td>

                    <td><span class="badge <?php echo e($category->status ==1 ? 'bg-primary' : 'bg-danger'); ?>">
                        <?php echo e($category->status ==1 ?'Active' : 'Inactive'); ?></span>
                    </td>
                    <td>
                        <a href="<?php echo e(route('categories.show', $category->id)); ?>"
                             class="btn btn-info btn-sm">Detail</a>
                        <a href="<?php echo e(route('categories.edit', $category->id)); ?>"
                             class="btn btn-warning btn-sm">Edit</a>
                        <form action="<?php echo e(route('categories.destroy', $category->id)); ?>" method="POST" class="d-inline"
                            onsubmit="return confirm('Are you sure you want to delete this category?');">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                        </form>
                    </td>
                </tr>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr><td><span>មិនមានទិន្នន័យ</span></td></tr>
            <?php endif; ?>
        </tbody>
        </table>
        <div class="d-flex justify-content-center">
            <?php echo e($categories->links()); ?>


        </div>
        <?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.app", array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/Desktop/blogApp/resources/views/categories/index.blade.php ENDPATH**/ ?>