<?php $__env->startSection("title", "Edit Post"); ?>

<?php $__env->startSection("content"); ?>

<a href="<?php echo e(route('posts.index')); ?>" class="btn btn-secondary mb-3">
    Back
</a>

<div class="card">
    <div class="card-body">
        <form action="<?php echo e(route('posts.update', $post->id)); ?>"
              method="POST"
              enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            
            <div class="mb-3">
                <label class="form-label">Title</label>
                <input type="text"
                       name="title"
                       class="form-control"
                       value="<?php echo e(old('title', $post->title)); ?>">
            </div>

            
            <div class="mb-3">
                <label class="form-label">Category</label>
                <select name="category_id" class="form-control">
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($category->id); ?>"
                            <?php echo e($post->category_id == $category->id ? 'selected' : ''); ?>>
                            <?php echo e($category->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            
            <div class="mb-3">
                <label class="form-label">Content</label>
                <textarea name="content"
                          rows="5"
                          class="form-control"><?php echo e(old('content', $post->content)); ?></textarea>
            </div>

            
            <div class="mb-3">
                <label class="form-label">Image</label><br>
                <?php if($post->image): ?>
                    <img src="<?php echo e(asset('storage/' . $post->image)); ?>"
                         width="120"
                         class="mb-2">
                <?php endif; ?>
                <input type="file" name="image" class="form-control">
            </div>

            
            <div class="mb-3">
                <label class="form-label">Status</label>
                <select name="status" class="form-control" required>
                    <option value="">-- Select Status --</option>
                    <option value="draft" <?php echo e(old('status') == 'draft' ? 'selected' : ''); ?>>
                        Draft
                    </option>
                    <option value="published" <?php echo e(old('status') == 'published' ? 'selected' : ''); ?>>
                        Published
                    </option>
                    <option value="archived" <?php echo e(old('status') == 'archived' ? 'selected' : ''); ?>>
                        Archived
                    </option>
                </select>

            </div>

            <button type="submit" class="btn btn-warning">
                Update Post
            </button>
        </form>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.app", array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/Desktop/blogApp/resources/views/posts/edit.blade.php ENDPATH**/ ?>